<?php
if ( defined( 'WPB_VC_VERSION' ) ) {
	class WPBakeryShortCode_sm_multi_scroll extends WPBakeryShortCodesContainer {
		function content($atts, $content = null) {
			return sm_multi_scroll_func( $atts, $content );
		}
	}
} else {
	add_shortcode( 'sm_multi_scroll', 'sm_multi_scroll_func' );
}

function sm_multi_scroll_func( $atts, $content = "" ) {
	$view_params = array(
		'atts' => $atts,
		'content' => $content
	);
	return sm_render_view( 'multi-scroll', $view_params );
}

function sm_filter_multiscroll_style( $tag, $handle ) {
	if ( 'multiscroll' == $handle )
		return str_replace( 'rel', 'property="stylesheet" rel', $tag );
	return $tag;
}

add_action( 'vc_before_init', 'vc_map_sm_multi_scroll' );
function vc_map_sm_multi_scroll() {
	vc_map( array(
		'name' => esc_html__( 'Multi Scroll', 'semona-extension' ),
		'base' => 'sm_multi_scroll',
		'icon' => SM_PLUGIN_URL . '/assets/images/shortcodes/icon-multi_scroll.png',
		'category' => esc_html__( 'by Theme-Paradise', 'semona-extension' ),
		'description' => esc_html__( 'Multi-scrolling container with split screen', 'semona-extension' ),
		'as_parent' => array( 'only' => 'sm_multi_scroll_left_side, sm_multi_scroll_right_side' ),
		'content_element' => true,
		'params' => array(
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Navigation Bullet Shape', 'semona-extension' ),
				'value' => sm_get_nav_bullet_shapes_array(),
				'param_name' => 'bullet_shape',
				'description' => esc_html__( 'Select navigation bullet shape.', 'semona-extension' ),
			),
			array(
				'type' => 'colorpicker',
				'heading' => esc_html__( 'Custom Navigation Bullet Color', 'semona-extension' ),
				'param_name' => 'bullet_color',
				'description' => esc_html__( 'Select custom navigation bullet color.', 'semona-extension' ),
			),
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Left Section Width Percentage', 'semona-extension' ),
				'value' => '',
				'param_name' => 'left_section_width',
				'description' => esc_html__( 'Enter a number between 1 and 99 for left section width percentage, in percent without %. Right section will be automatically calculated as 100 minus entered number. Leave blank to use default value 50.', 'semona-extension' ),
			),
			sm_extra_class()
		),
		'default_content' => '
	[sm_multi_scroll_left_side][sm_multi_scroll_section][/sm_multi_scroll_section][/sm_multi_scroll_left_side]
	[sm_multi_scroll_right_side][sm_multi_scroll_section][/sm_multi_scroll_section][/sm_multi_scroll_right_side]
	',
		'js_view' => 'VcColumnView',
	) );
}

